<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet" media="print" onload="this.media='all'">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10" defer></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: #f1f3f6;
            min-height: 100vh;
            padding: 15px;
            overflow-x: hidden;
        }
        .main-container {
            max-width: 960px;
            margin: 15px auto;
            padding: 0 15px;
        }
        .service-card {
            background: #ffffff;
            border-radius: 18px;
            box-shadow: 0 18px 45px rgba(15, 23, 42, 0.15);
            padding: 28px 24px 26px;
            border: 1px solid #e3e6f0;
        }
        @media (min-width: 768px) {
            .main-container {
                max-width: 980px;
            }
            .service-card {
                padding: 32px 32px 30px;
            }
        }
        .service-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .service-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);
        }
        .service-icon i {
            font-size: 36px;
            color: white;
        }
        .service-title {
            font-size: 24px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 8px;
        }
        .service-subtitle {
            font-size: 14px;
            color: #64748b;
            margin-bottom: 15px;
        }
        .service-fee {
            display: inline-block;
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            color: white;
            padding: 8px 20px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 16px;
        }
        .wallet-info {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 15px 20px;
            border-radius: 12px;
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .wallet-info .balance-label {
            font-size: 14px;
            opacity: 0.9;
        }
        .wallet-info .balance-amount {
            font-size: 20px;
            font-weight: 700;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-label {
            font-weight: 600;
            color: #334155;
            margin-bottom: 8px;
            font-size: 14px;
        }
        .form-control {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 12px 16px;
            font-size: 15px;
            transition: all 0.3s;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }
        .submit-btn {
            width: 100%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 14px 24px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }
        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.6);
        }
        .submit-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        .info-box {
            background: #f8fafc;
            border-left: 4px solid #667eea;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .info-box ul {
            margin: 0;
            padding-left: 20px;
        }
        .info-box li {
            margin: 5px 0;
            color: #475569;
            font-size: 14px;
        }
    </style>
</head>
<body>

<?php
// Start session if not started
if (!isset($_SESSION)) {
    session_start();
}

include('../header.php');

$service_fee = 70; // ₹70 for all in one panel

// Initialize debug info array
$debug_info = [];

// If $udata is not set, try to get user data from session or database
if (!isset($udata) || empty($udata)) {
    // Debug: Check all session variables
    $debug_info[] = "Session variables: " . (isset($_SESSION) ? implode(', ', array_keys($_SESSION)) : 'SESSION not set');
    
    // Try multiple session variable names
    $session_phone = $_SESSION['phone'] ?? $_SESSION['username'] ?? $_SESSION['user_phone'] ?? $_SESSION['mobile'] ?? '';
    
    $debug_info[] = "Session phone/username: " . ($session_phone ?: 'NOT FOUND');
    
    if (!empty($session_phone) && isset($ahk_conn)) {
        $phone_escaped = mysqli_real_escape_string($ahk_conn, $session_phone);
        $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$phone_escaped' LIMIT 1");
        if ($user_query && mysqli_num_rows($user_query) > 0) {
            $udata = mysqli_fetch_assoc($user_query);
            $debug_info[] = "User data fetched from DB using phone: $phone_escaped";
        } else {
            // Try username field
            $user_query2 = mysqli_query($ahk_conn, "SELECT * FROM users WHERE username='$phone_escaped' LIMIT 1");
            if ($user_query2 && mysqli_num_rows($user_query2) > 0) {
                $udata = mysqli_fetch_assoc($user_query2);
                $debug_info[] = "User data fetched from DB using username: $phone_escaped";
            } else {
                $debug_info[] = "No user found in DB for: $phone_escaped";
            }
        }
    } else {
        $debug_info[] = "Session phone/username not found and ahk_conn: " . (isset($ahk_conn) ? 'SET' : 'NOT SET');
    }
}

// Helper: get fresh wallet balance from database
function get_panel_wallet_balance($conn, $phone) {
    if (empty($phone)) {
        error_log("get_panel_wallet_balance: Phone is empty");
        return 0.0;
    }
    $phone_safe = mysqli_real_escape_string($conn, $phone);
    $res = mysqli_query($conn, "SELECT balance FROM users WHERE phone='$phone_safe' LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $row = mysqli_fetch_assoc($res);
        $balance = (float)$row['balance'];
        error_log("get_panel_wallet_balance: Phone=$phone_safe, Balance=$balance");
        return $balance;
    }
    error_log("get_panel_wallet_balance: No user found for phone=$phone_safe");
    return 0.0;
}

if (isset($_POST['apply'])) {
    
    // CRITICAL: Set error reporting to catch any issues
    error_reporting(E_ALL);
    ini_set('display_errors', 0); // Don't display errors, but log them
    
    // Debug: Log that form was submitted
    error_log("Voter Details Apply - Form submitted");
    error_log("Voter Details Apply - POST data: " . print_r($_POST, true));
    error_log("Voter Details Apply - udata check: " . (isset($udata) ? 'SET' : 'NOT SET'));
    if (isset($udata)) {
        error_log("Voter Details Apply - udata phone: " . ($udata['phone'] ?? 'NOT SET'));
        error_log("Voter Details Apply - udata balance: " . ($udata['balance'] ?? 'NOT SET'));
    }
    
    // Check if ahk_conn is set
    if (!isset($ahk_conn)) {
        error_log("Voter Details Apply - ERROR: ahk_conn not set");
        ?>
        <script>
        if (typeof Swal !== 'undefined') {
            Swal.fire('Database Error','Database connection not found. Please refresh the page.','error');
        } else {
            alert('Database Error: Database connection not found. Please refresh the page.');
        }
        </script>
        <?php
        exit;
    }

    // Check if voter_number is provided
    if (!isset($_POST['voter_number']) || empty(trim($_POST['voter_number']))) {
        ?>
        <script>
        if (typeof Swal !== 'undefined') {
            Swal.fire('Invalid Input','Please enter Voter Number/EPIC Number','error');
        } else {
            alert('Invalid Input: Please enter Voter Number/EPIC Number');
        }
        </script>
        <?php
        exit;
    }

    $voter_number = mysqli_real_escape_string($ahk_conn, trim($_POST['voter_number']));
    
    // Check if $udata is set
    if (!isset($udata) || empty($udata['phone'])) {
        error_log("Voter Details Apply - ERROR: udata not set or phone missing");
        ?>
        <script>
        if (typeof Swal !== 'undefined') {
            Swal.fire('Error','User data not found. Please login again.','error');
            setTimeout(()=>{window.location='../login.php'},2000);
        } else {
            alert('Error: User data not found. Please login again.');
            setTimeout(()=>{window.location='../login.php'},2000);
        }
        </script>
        <?php
        exit;
    }

    // EXACT same approach as pan-apply.php
    $appliedby     = $udata['phone'];
    $wallet_amount = floatval($udata['balance']);
    
    error_log("Voter Details Apply - Processing: Phone=$appliedby, Balance=$wallet_amount, Voter Number=$voter_number");

    /* ===== WALLET CHECK ===== */
    if ($wallet_amount < $service_fee) {
        ?>
        <script>
        if (typeof Swal !== 'undefined') {
            Swal.fire(
                'Insufficient Balance',
                'Required ₹<?php echo $service_fee; ?> | Balance ₹<?php echo number_format($wallet_amount,2); ?>',
                'error'
            );
        } else {
            alert('Insufficient Balance: Required ₹<?php echo $service_fee; ?> | Balance ₹<?php echo number_format($wallet_amount,2); ?>');
        }
        </script>
        <?php
    } else {

        /* ===== WALLET DEBIT ===== */
        $nbal = $wallet_amount - $service_fee;
        $debit = mysqli_query(
            $ahk_conn,
            "UPDATE users SET balance=balance-$service_fee WHERE phone='$appliedby'"
        );

        if (!$debit) {
            ?>
            <script>
            if (typeof Swal !== 'undefined') {
                Swal.fire('Error','Wallet deduction failed','error');
            } else {
                alert('Error: Wallet deduction failed');
            }
            </script>
            <?php
        } else {

            mysqli_query($ahk_conn, "INSERT INTO wallethistory
                (userid,amount,balance,purpose,status,type)
                VALUES
                ('$appliedby','$service_fee','$nbal',
                 'Voter Details Application - Voter Number: $voter_number','1','Debit')");

            /* ===== API CALL ===== */
            $api_key = "mk_77f66f75a09a7a5fc5eea4a17803ad9e"; // Admin API Key
            $api_url = "https://lostdata.co.in/api/voter-details-apply.php";

            $postData = [
                'api_key' => $api_key,
                'voter_number' => $voter_number
            ];

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);

            // Debug logging
            error_log("Voter Details API Call - URL: $api_url");
            error_log("Voter Details API Call - POST Data: " . print_r($postData, true));
            error_log("Voter Details API Call - HTTP Code: $http_code");
            error_log("Voter Details API Call - cURL Error: $curl_error");
            error_log("Voter Details API Call - Response: " . substr($response, 0, 500));

            // Check if response is valid JSON
            if (empty($response)) {
                $success = false;
                $error = "Empty response from API";
                $message = "No response received from API server";
                error_log("Voter Details API - Empty response");
            } else {
                $result  = json_decode($response, true);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    $success = false;
                    $error = "Invalid JSON response";
                    $message = "API returned invalid JSON: " . json_last_error_msg();
                    error_log("Voter Details API - JSON decode error: " . json_last_error_msg());
                    error_log("Voter Details API - Raw response: " . substr($response, 0, 500));
                } else {
                    $success = $result['success'] ?? false;
                    $error   = $result['error'] ?? '';
                    $message = $result['message'] ?? '';
                    
                    // Debug: Log the result
                    error_log("Voter Details API Result - Success: " . ($success ? 'true' : 'false'));
                    error_log("Voter Details API Result - Error: " . $error);
                    error_log("Voter Details API Result - Message: " . $message);
                    error_log("Voter Details API Result - Full Response: " . substr($response, 0, 1000));
                }
            }

            /* ===== ERROR → REFUND ===== */
            if ($curl_error || !$success || $http_code != 200) {

                mysqli_query($ahk_conn,
                    "UPDATE users SET balance=balance+$service_fee WHERE phone='$appliedby'"
                );

                mysqli_query($ahk_conn, "INSERT INTO wallethistory
                    (userid,amount,balance,purpose,status,type)
                    VALUES
                    ('$appliedby','$service_fee','$wallet_amount',
                     'Voter Details Application Refund - API Failed','1','Credit')");

                $error_message = $message ?: ($error ?: "Application submission failed. Amount refunded.");
                if ($curl_error) {
                    $error_message .= " (cURL Error: $curl_error)";
                }
                if ($http_code != 200) {
                    $error_message .= " (HTTP Code: $http_code)";
                }
                if (!empty($response)) {
                    $error_message .= " (Response: " . substr($response, 0, 200) . ")";
                }
                ?>
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Processing...</title>
                    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                </head>
                <body>
                <script>
                if (typeof Swal !== 'undefined') {
                    Swal.fire(
                        'Error',
                        '<?php echo addslashes($error_message); ?>',
                        'error'
                    ).then(() => {
                        window.location.href = 'voter-details-apply.php';
                    });
                } else {
                    alert('<?php echo addslashes($error_message); ?>');
                    setTimeout(()=>{window.location.href='voter-details-apply.php'},3000);
                }
                </script>
                </body>
                </html>
                <?php
                exit;
            } 
            /* ===== SUCCESS ===== */
            else {

                date_default_timezone_set("Asia/Kolkata");
                $time = date('d/m/Y g:i:s');

                // Get application data from API response
                $app_data = $result['application'] ?? [];
                $application_id = $app_data['id'] ?? '';
                $application_no = $app_data['application_no'] ?? 'VD' . $application_id;
                $status = $app_data['status'] ?? 'Pending';
                $new_balance = $result['user_info']['new_balance'] ?? $nbal;

                // Build success message HTML
                ?>
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Success</title>
                    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                </head>
                <body>
                <script>
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Application Submitted!',
                        html: `
                            <div style="text-align: left; padding: 10px;">
                                <p><strong>Application No:</strong> <?php echo $application_no; ?></p>
                                <p><strong>Voter Number:</strong> <?php echo htmlspecialchars($voter_number); ?></p>
                                <p><strong>Status:</strong> <span class="badge bg-warning">Pending</span></p>
                                <p><strong>Service Fee:</strong> ₹<?php echo $service_fee; ?></p>
                                <hr>
                                <p><strong>Old Balance:</strong> ₹<?php echo number_format($wallet_amount, 2); ?></p>
                                <p><strong>Deducted:</strong> ₹<?php echo number_format($service_fee, 2); ?></p>
                                <p><strong>New Balance:</strong> ₹<?php echo number_format($new_balance, 2); ?></p>
                            </div>
                        `,
                        confirmButtonText: 'View Applications',
                        confirmButtonColor: '#667eea'
                    }).then((result) => {
                        window.location.href = 'voter-details-list.php';
                    });
                } else {
                    alert('Application Submitted Successfully!\nApplication No: <?php echo $application_no; ?>\nVoter Number: <?php echo htmlspecialchars($voter_number); ?>');
                    setTimeout(() => {
                        window.location.href = 'voter-details-list.php';
                    }, 2000);
                }
                </script>
                </body>
                </html>
                <?php
                exit;
            }
        }
    }
}

// Refresh user balance - EXACT same approach as pan-apply.php
// Debug: Check what's in $udata (only if not already initialized)
if (!isset($debug_info)) {
    $debug_info = [];
}
$debug_info[] = "udata keys: " . (isset($udata) ? implode(', ', array_keys($udata)) : 'udata not set');
$debug_info[] = "udata[phone]: " . (isset($udata['phone']) ? $udata['phone'] : 'NOT SET');
$debug_info[] = "udata[balance]: " . (isset($udata['balance']) ? $udata['balance'] : 'NOT SET');

// Try database query first (like pan-apply.php)
if (isset($udata['phone']) && !empty($udata['phone'])) {
    $phone_val = $udata['phone'];
    $query_result = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='{$phone_val}'");
    if ($query_result) {
        $fresh_user = mysqli_fetch_assoc($query_result);
        $debug_info[] = "DB Query: SUCCESS";
        $debug_info[] = "DB balance: " . (isset($fresh_user['balance']) ? $fresh_user['balance'] : 'NOT FOUND');
        $current_balance = $fresh_user['balance'] ?? $udata['balance'] ?? 0.0;
    } else {
        $debug_info[] = "DB Query: FAILED - " . mysqli_error($ahk_conn);
        $current_balance = isset($udata['balance']) ? floatval($udata['balance']) : 0.0;
    }
} else {
    $debug_info[] = "Phone not available in udata";
    $current_balance = isset($udata['balance']) ? floatval($udata['balance']) : 0.0;
}
?>

<div class="main-container">
    <div class="service-card">
        <div class="service-header">
            <div class="service-icon">
                <i class="fas fa-vote-yea"></i>
            </div>
            <h1 class="service-title">Voter Details Finder</h1>
            <p class="service-subtitle">Voter Number/EPIC Number से Voter Details खोजें</p>
            <span class="service-fee">Service Charge: ₹<?php echo $service_fee; ?></span>
        </div>

        <div class="wallet-info">
            <div>
                <div class="balance-label">Your Wallet Balance</div>
                <div class="balance-amount">₹<?php echo number_format($current_balance, 2); ?></div>
                <!-- Temporary Debug Info -->
                <div style="margin-top: 10px; padding: 10px; background: rgba(0,0,0,0.1); border-radius: 5px; font-size: 0.7rem;">
                    <strong>Debug Info:</strong><br>
                    <?php foreach($debug_info as $info): ?>
                        <?php echo htmlspecialchars($info); ?><br>
                    <?php endforeach; ?>
                </div>
            </div>
            <div style="text-align: right;">
                <small style="opacity: 0.8;">Auto-deduct on success</small>
            </div>
        </div>

        <div class="info-box">
            <strong><i class="fas fa-info-circle me-2"></i>Service Information:</strong>
            <ul>
                <li>अपने Voter ID/EPIC नंबर से Voter Details खोजें</li>
                <li>Service Fee: ₹<?php echo $service_fee; ?> (One-time payment)</li>
                <li>आपको 24 घंटे के अंदर Voter Card PDF मिल जाएगी</li>
                <li>WhatsApp पर notification मिलेगा</li>
            </ul>
        </div>

        <form method="post" id="applyForm">
            <div class="form-group">
                <label class="form-label">
                    <i class="fas fa-vote-yea me-2"></i>Voter Number / EPIC Number <span class="text-danger">*</span>
                </label>
                <input type="text" 
                       class="form-control" 
                       name="voter_number" 
                       placeholder="Enter Voter ID / EPIC Number" 
                       required
                       value="<?php echo isset($_POST['voter_number']) ? htmlspecialchars($_POST['voter_number']) : ''; ?>">
                <small class="text-muted">वह Voter ID/EPIC Number डालें जिसकी Details चाहिए</small>
            </div>

            <button type="submit" name="apply" class="submit-btn" id="submitBtn">
                <i class="fas fa-search me-2"></i>Find Voter Details (₹<?php echo $service_fee; ?>)
            </button>
        </form>
    </div>
</div>

<script>
document.getElementById('applyForm').addEventListener('submit', function(e) {
    console.log('Form submitted');
    const btn = document.getElementById('submitBtn');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
    // Form will submit normally to process the POST request
});

// Check if there's a PHP error message in the page
window.addEventListener('load', function() {
    <?php if (isset($_POST['apply'])): ?>
    console.log('Form was submitted (POST detected)');
    <?php endif; ?>
});
</script>

</body>
</html>
